
## monthly theme

- chatgpt 1 year anniversary
	- https://news.ycombinator.com/item?id=38481970
	- https://sub.thursdai.news/p/thursdai-nov-30-chatgpt-1-year-celebration
	- https://www.youtube.com/watch?v=towISIgfQw8
	- https://www.theverge.com/23981318/chatgpt-open-ai-launch-anniversary-future
- voice cloning red alert
	- voice cloning https://twitter.com/martin_casado/status/1726707806492131819
	- and here https://x.com/notcapnamerica/status/1725901659270742084?s=20
	- https://github.com/w-okada/voice-changer/
		- https://www.weights.gg/
- consistency models and GPT4V coding
	- was [teased in Jan/Feb](https://x.com/okarisman/status/1721629198094078458?s=20), with distilled versions of Stable Diffusion, but only broke through with LCM-LoRAs which can turn regular SD models into pseudo-LCM models
	- Krea - [moving the sun in real-time](https://twitter.com/TitusTeatus/status/1723961348101677353)
	- TLDraw makeitreal
	- [enabled by FAL.ai](https://twitter.com/burkaygur/status/1725626154231492684)
	- https://github.com/abi/screenshot-to-code
	- one step diffusion - SDXL turbo https://twitter.com/StabilityAI/status/1729589510155948074
		- https://stability.ai/news/stability-ai-sdxl-turbo
		- use on [Draw Things](https://twitter.com/drawthingsapp/status/1729633231526404400)
	- can try with [HuggingFace Diffusers](https://huggingface.co/spaces/latent-consistency/super-fast-lcm-lora-sd1.5) ([blogpost](https://huggingface.co/blog/lcm_lora)) more demos [here](https://huggingface.co/collections/latent-consistency/latent-consistency-model-demos-654e90c52adb0688a0acbe6f)
- video is real and good now
	- pika https://twitter.com/karpathy/status/1729545506890932536?s=12&t=90xQ8sGy63D2OtiaoGJuww
- people need to calm the fuck down 
	- Q* mass hysteria 
		- [complete nonsense](https://twitter.com/ylecun/status/1728126868342145481)
		- with some [4chan leaks](https://docs.google.com/document/u/0/d/1RyVP2i9wlQkpotvMXWJES7ATKXjUTIwW2ASVxApDAsA/mobilebasic)? my contacts say this isnt reliable
	- OpenAI leadership drama
- the sour lesson 
	- from anatomy to operating systems
	- https://twitter.com/karpathy/status/1723140519554105733?s=12&t=90xQ8sGy63D2OtiaoGJuww

## OpenAI
- [Ilya Sutskever on No Priors pod](https://www.youtube.com/watch?v=Ft0gTO2K85A)
- dev day
	- GPTs: Custom versions of ChatGPT - https://news.ycombinator.com/item?id=38166431
	- OpenAI releases Whisper v3, new generation open source ASR model - https://news.ycombinator.com/item?id=38166965
		- https://twitter.com/YoungPhlo_/status/1721606700082336013
	- OpenAI DevDay, Opening Keynote Livestream [video] - https://news.ycombinator.com/item?id=38165090
		- 100m MAU later revealed to [be 14m DAU](https://www.newyorker.com/magazine/2023/12/11/the-inside-story-of-microsofts-partnership-with-openai?utm_source=substack&utm_medium=email)
	- gpt4 turbo was claimed to be better than GPT4, however [some tests](https://x.com/wangzjeff/status/1722075037799530882?s=20) and [anecdotal reviews](https://twitter.com/HamelHusain/status/1730408823670940043) disagree.
	- vision
		- openinterpreter integration https://twitter.com/hellokillian/status/1723106008061587651
	- gpts
		- curations of [GPTs from community](https://github.com/AgentOps-AI/BestGPTs)
		- [gdb personal favorite](https://twitter.com/gdb/status/1721638249414947235)
		- useful for low level systems developers [reading docs](https://news.ycombinator.com/item?id=38192094)
		- https://news.ycombinator.com/item?id=38166431
		- typist https://twitter.com/_Borriss_/status/1725208054185046071
		- [grimoire](https://chat.openai.com/g/g-n7Rs0IK86-grimoire) (coding wizard)
		- [DesignerGPT](https://twitter.com/skirano/status/1723026266608033888?s=12&t=90xQ8sGy63D2OtiaoGJuww) - create websites in chatgpt
		- [VisualWeatherGPT](https://twitter.com/altryne/status/1722498086256411075) from altryne
		- [uses Qdrant for vector db](https://news.ycombinator.com/item?id=38280859)
		- jailbreaking them is [easy](https://twitter.com/literallydenis/status/1729147010748424375). can also download [uploaded files](https://twitter.com/kanateven/status/1722762002475475426?s=12&t=90xQ8sGy63D2OtiaoGJuww) causing Levels.fyi leaked data ([response from founder](https://twitter.com/zuhayeer/status/1723065439910011055?s=12&t=90xQ8sGy63D2OtiaoGJuww)). here are prompts for [many many other GPTs](https://github.com/linexjlin/GPTs)
		- langchain launched an open source version https://github.com/langchain-ai/opengpts
	- chatgpt memory "rumor" https://twitter.com/yupiop12/status/1724915477900656857
	- json mode
		- [does not guarantee output will match your schema](https://community.openai.com/t/json-mode-vs-function-calling/476994/6) but will improve
		- [functions param deprecated!! no notice!](https://x.com/Tangpin78255362/status/1722049314103705650?s=20)
	- dalle3
		- the consistency model VAE decoder (used in DALL-E 3) for the Stable Diffusion 1.4/1.5 VAE https://twitter.com/iScienceLuvr/status/1721601915975528683
	- assistants
		- open source version https://github.com/stellar-amenities/assistants
- nov 14: paused chatgpt plus signups, ebay at premium https://x.com/sdand/status/1724629169483719104?s=20
- [Major outages across ChatGPT and API](https://news.ycombinator.com/item?id=38190401) - "I used Bard today. it's gotten a lot better."
	- but there was a high profile post [Hacking Google Bard - From Prompt Injection to Data Exfiltration](https://embracethered.com/blog/posts/2023/google-bard-data-exfiltration/)
- sama fired nov 17
	- was at cabridge https://www.youtube.com/watch?v=NjpNG0CJRMM
	- was at apec summit https://www.youtube.com/watch?v=ZFFvqRemDv8
	- you all know what happened
	- [sama's last interview](https://podcasts.apple.com/us/podcast/mayhem-at-openai-our-interview-with-sam-altman/id1528594034?i=1000635486878) before being fired
	- [greg](https://twitter.com/gdb/status/1727230819226583113) and [sama are so back](https://openai.com/blog/sam-altman-returns-as-ceo-openai-has-a-new-initial-board)
	- [profit cap structure has changed](https://x.com/MatthewJBar/status/1730715423522648493?s=20 - will rise 20% a year after 2025)
	- good behind the scenes reporting from [the New Yorker](https://www.newyorker.com/magazine/2023/12/11/the-inside-story-of-microsofts-partnership-with-openai?utm_source=substack&utm_medium=email)
- [will be releasing usage tracking based on API key for the OpenAI API](https://x.com/OfficialLoganK/status/1729194654963495307?s=20)
- gpt3.5 issues https://twitter.com/sharifshameem/status/1725422821730636236
	- zephyr great
- [interesting, nontechnical real life use cases for GPT4 from Reddit](https://www.reddit.com/r/OpenAI/comments/182zkdl/whats_the_hardest_real_life_problem_you_have/)
- Occasional reports of GPT4 nerfing [from biased individuals](https://twitter.com/erhartford/status/1729566883350012038) and [on the OpenAI discord](https://twitter.com/swyx/status/1729960492494696951)
- openAI [deno SDK](https://twitter.com/officiallogank/status/1730269205939790086?s=12&t=90xQ8sGy63D2OtiaoGJuww)
- ChatGPT anniversary
- [and 10 years at FAIR](https://x.com/soumithchintala/status/1730297950608208378?s=20)



## models

- Claude 2.1: offers an industry-leading 200K token context window (over 500 pages), a 2x decrease in hallucination rates, system prompts, tool use, and updated pricing.
	- https://www.anthropic.com/index/claude-2-1
	- model card https://www-files.anthropic.com/production/images/ModelCardClaude2_with_appendix.pdf?dm=1700589594
	- $1k test showing [declining utilization](https://twitter.com/GregKamradt/status/1727018183608193393) of the 200k context
- Inflection 2
	- https://news.ycombinator.com/item?id=38380377
	- [5,000 NVIDIA H100 GPUs in fp8 mixed precision for ~10²⁵ FLOPs](https://x.com/mustafasuleyman/status/1727349979440984371?s=20). guess is [300b model](https://twitter.com/EMostaque/status/1727373950685200674) on 5T tokens
	- [slightly better than llama-2](https://x.com/Teknium1/status/1727353306132185181?s=20)
	- 1% of [rumored GPT5 compute](https://twitter.com/wagieeacc/status/1714458385624506679)
- [Yarn-Mistral-7b-128k](https://x.com/mattshumer_/status/1720115354884514042?s=20): 
	- 4x more context than GPT-4. Open-source is the new long-context king! This thing can easily fit entire books in a prompt.
	- [tweet](https://x.com/theemozilla/status/1720107186850877662?s=20)
- Yi 01 ai 34B released https://twitter.com/kaifulee/status/1721321096727994590
	- with [100B rumored soon](https://news.ycombinator.com/item?id=38483611)
- Orca 2 https://arxiv.org/abs/2311.11045
	- https://www.microsoft.com/en-us/research/blog/orca-2-teaching-small-language-models-how-to-reason/
	- Orca 1 learns from rich signals, such as explanation traces, allowing it to outperform conventional instruction-tuned models on benchmarks like BigBench Hard and AGIEval. 
	- In Orca 2, we continue exploring how improved training signals can enhance smaller LMs' reasoning abilities. 
	- In Orca 2, we teach the model various reasoning techniques (step-by-step, recall then generate, recall-reason-generate, direct answer, etc.). 
	- Orca 2 significantly surpasses models of similar size and attains performance levels similar ****or better to those of models 5-10x larger, as assessed on complex tasks that test advanced reasoning abilities in zero-shot settings.
- Amazon Mistral - 32k
	- https://twitter.com/MatthewBerman/status/1719758392510824505
- [Qwen-72B and Qwen-1.8B release](https://twitter.com/huybery/status/1730127387109781932?s=12&t=90xQ8sGy63D2OtiaoGJuww): 32K context, trained on 3T tokens, <100M MAU commercial license, strong benchmark performance
* [DeepSeek LLM 67B](https://twitter.com/deepseek_ai/status/1729881611234431456) - 4K context, 2T tokens, Apache 2.0 license, strong on code (although DeepSeek Code 33B it benches better)
	* can try https://chat.deepseek.com
	* ![https://pbs.twimg.com/media/GAJDUfTXoAAs4eE?format=jpg&name=large](https://pbs.twimg.com/media/GAJDUfTXoAAs4eE?format=jpg&name=large)
- Elon X.ai Grok
	- Grok-1 is a autoregressive Transformer-based model pre-trained to perform next-token prediction. The model was then fine-tuned using extensive feedbacks from both human and the early Grok-0 models. The initial Grok-1 has a context length of 8,192 tokens and is released in Oct 2023. https://twitter.com/altryne/status/1721028995456647286
	- grok vs openchat - https://twitter.com/alignment_lab/status/1721308271946965452
	- funny [exchange between sama and elon](https://twitter.com/sama/status/1722766374588830101?s=12&t=90xQ8sGy63D2OtiaoGJuww) on Grok vs GPTs
	- [notes on x.ai team](https://twitter.com/DrJimFan/status/1679180398134448132):
		- - Jimmy Ba: Adam (default optimizer for modern NNs), Layer Normalization (critical building block of Transformer). - 
		- Igor Babuschkin: AlphaStar (DeepMind's StarCraft player that beats human champions). - 
		- Christian Szegedy: BatchNorm (key component of ResNet that made training stable). - 
		- Yuhuai "Tony" Wu: AlphaStar, OpenAI Baselines (widely adopted RL library), PaLM-2 - 
		- [Greg Yang](https://twitter.com/TheGregYang/status/1679168317897211910): deep learning theory - 
		- Zihang Dai: Transformer-XL (adding recurrence to extend beyond a fixed context window), XLNet - and many others
- Microsoft Phi-2 at Ignite - 2.7b params, 50% better at math
	- https://x.com/abacaj/status/1724850925741768767?s=20
	- 213b tokens
		- some insight from [openPhi attempt at replication](https://x.com/ocolegro/status/1725189919931310450?s=20)
	- synthetic data from GPT3.5
- [Gorilla OpenFunctions](https://gorilla.cs.berkeley.edu/blogs/4_open_functions.html)
	- open-source function calling model, and are thrilled to present Gorilla OpenFunctions. And yes, we've made parallel functions a reality in open-source!
	- https://twitter.com/shishirpatil_/status/1725251917394444452
	- but [different format than OpenAI](https://x.com/_philschmid/status/1727669280370515988?s=20)
- Stable Video Diffusion
	- [Animate anyone](https://news.ycombinator.com/item?id=38368287) - however no code available - but Magic Animate is [on Replicate](https://twitter.com/lucataco93/status/1731899064357212172)
		- https://x.com/StelfieTT/status/1731378027970338946?s=20
	- and video LLaVA https://news.ycombinator.com/item?id=38366830
	- and Animate Anyone https://humanaigc.github.io/animate-anyone/
	- and Pika
	- [PhotoAI into VideoAI](https://twitter.com/levelsio/status/1729621624062611835)
	- and launching [Stability Memberships](https://twitter.com/EMostaque/status/1729609312601887109), a game engine licensing model
- [StyleTTS 2: Towards Human-Level Text-to-Speech through Style Diffusion and Adversarial Training with Large Speech Language Models](https://github.com/yl4579/StyleTTS2)
	- ["Eleven-labs quality"](https://news.ycombinator.com/item?id=38335255) - but "Not sure it's quite up to Eleven Labs quality. But to me, what makes Eleven so cool is that they have a large library of high quality voices that are easy to choose from.... the real special sauce for Eleven is the near instant voice cloning with just a single 5 minute sample, which works shockingly (even spookily) well."
- Small models: We trained a small transformer (100M params) for basic arithmetic. W. the right training data it nails 12x12 digits multiplication w/o CoT (that's 10^24 possibilities, so no it's not memorization. ([tweet](https://twitter.com/SebastienBubeck/status/1729517609669030071))
- [HelixNet](https://twitter.com/migtissera/status/1720567034315186588?s=12&t=90xQ8sGy63D2OtiaoGJuww) is a novel Deep Learning architecture consisting of 3 x Mistral-7B LLMs. It has an actor, a critic, and a regenerator.
- Cohere embed v3 embeddings https://txt.cohere.com/introducing-embed-v3/ - sota MTEB and BEIR benchmarks.


## Fundraising

- Together AI $102.5m Series A
	- https://www.newcomer.co/p/cloud-platform-startup-together-ai
	- also announcing [Together Inference Engine](https://www.together.ai/blog/together-inference-engine-v1) - 117 tokens per second on Llama-2-70B-Chat and 171 tokens per second on Llama-2-13B-Chat
- Mistral @ 2bn https://archive.ph/hkWD3
- Factory.ai $5m seed https://www.factory.ai/blog https://x.com/matanSF/status/1720106297096593672?s=20
- Ozone [$7m seed](https://twitter.com/maxvwolff/status/1722311661611360479) for "creating video 10x faster than a human would through context-aware AI."
- [Pika Labs $55m seed/Series A](https://x.com/karpathy/status/1729545506890932536?s=46&t=6FDPaNxZcbSsELal6Sv7Ug) ([Forbes](https://www.forbes.com/sites/kenrickcai/2023/11/27/pika-ai-video-generator-editor-series-a/?ss=ai&sh=58563005421b))
- [HeyGen launch](https://twitter.com/HeyGen_Official/status/1729863029947236765) - $5.6m funding
- [Modal labs raised $16m series A with Redpoint](https://twitter.com/modal_labs/status/1711748224610943163?s=12&t=90xQ8sGy63D2OtiaoGJuww)
- Voltage Park - [New nonprofit backed by crypto billionaire scores AI chips worth $500M](https://techcrunch.com/2023/10/31/new-nonprofit-backed-by-crypto-billionaire-scores-ai-chips-worth-500m/)


## open source projects

- david attenborough project
	- launch https://news.ycombinator.com/item?id=38281079 
	- [github](https://github.com/cbh123/narrator)
	- [arstechnica](https://news.ycombinator.com/item?id=38302319)
- anyscale llm benchmarking standards https://twitter.com/robertnishihara/status/1719760646211010997
- Replicate labs
	- YouTune - [finetune image models on yt videos](https://x.com/charliebholtz/status/1719847667495231700?s=20)
- Finetuning
	- [gpt evaluator as judge](https://x.com/llama_index/status/1719868813318271242?s=20) - from llamaindex
	- [Learnings from fine-tuning LLM on my Telegram messages](https://github.com/furiousteabag/doppelganger)
- llama index + pplx api https://x.com/llama_index/status/1725975990911086932?s=46&t=90xQ8sGy63D2OtiaoGJuww
- sharing screen with gpt4 vision
	- https://twitter.com/suneel_matham/status/1722538037551530069
	- https://github.com/hackgoofer/PeekPal
- insanely-fast-whisper-with-diarisation https://twitter.com/reach_vb/status/1729251580371689821
- ggml - [tutorial for setting up llama.cpp on AWS instances](https://twitter.com/ggerganov/status/1729232091370369160)
	- you can use one of the cheapest 16GB VRAM (NVIDIA T4) instances to serve a quantum Mistral 7B model to multiple clients in parallel with full context.
	- 3B LLaMA provisioned for 1 month is $15k? You can run quantum 13B on the g4dn.xlarge instance above for ~$500/month
- [LMsys introduced **lookahead decoding**](https://lmsys.org/blog/2023-11-21-lookahead-decoding/), a new, exact, and parallel decoding algorithm to accelerate LLM inference. a step above  [speculative decoding](https://arxiv.org/abs/2211.17192) (including [Medusa](https://sites.google.com/view/medusa-llm) and [OSD](https://arxiv.org/abs//2310.07177))
- [react-native ai](https://github.com/dabit3/react-native-ai) from Nader Dabit!
	- Full stack framework for building cross-platform mobile AI apps supporting LLM real-time / streaming text and chat UIs, image services and natural language to images with multiple models, and image processing.
- [llamafile](https://github.com/Mozilla-Ocho/llamafile) ([HN](https://news.ycombinator.com/item?id=38464057), [Blogpost](https://hacks.mozilla.org/2023/11/introducing-llamafile/), [simonw writeup](https://simonwillison.net/2023/Nov/29/llamafile/)): 
	- I think my favourite thing about llamafile is what it represents. This is a single binary file which you can download and then use, forever, on (almost) any computer.
	- You don’t need a network connection, and you don’t need to keep track of more than one file.
	- Stick that file on a USB stick and stash it in a drawer as insurance against a future apocalypse. You’ll never be without a language model ever again.
- gpt-fast - [a demo codebase for accelerating models with native PyTorch](https://pytorch.org/blog/accelerating-generative-ai-2/) using Torch.compile, quantization, speculative decoding, and tensor parallelism
	- 246tok/s - "[This is the fastest inference **by far** I've seen.](https://twitter.com/HamelHusain/status/1730309081288863910)esp without TensorRT
- [Open Source Chat with PDF tutorial using pd3f OCR + MistraLite + Prompts](https://x.com/HarperSCarroll/status/1722421505529892956?s=20)
- [VimGPT](https://github.com/ishan0102/vimGPT) - Using GPT-4 Vision with Vimium to browse the web

## other launches

- [Microsoft Ignite](https://www.youtube.com/watch?v=79wFBN5PffA) and [AWS Re:invent](https://www.youtube.com/watch?v=Sdh_EUL_hoo) announcements
	- [Gemini's absence is deafening](https://twitter.com/DrJimFan/status/1721925576666370365)
- Elon Musk's X.ai Grok model was announced but not widely released [HN](https://news.ycombinator.com/item?id=38148396)
	- "A unique and fundamental advantage of Grok is that it has real-time knowledge of the world via the X platform."
	- The engine powering Grok is Grok-1, our frontier LLM, which we developed over the last four months. Grok-1 has gone through many iterations over this span of time. [Model Card](https://x.ai/model-card/)
	- [https://x.ai/](https://x.ai/) - Link to waitlist: [https://grok.x.ai/](https://grok.x.ai/) 
	- [UI demo](https://twitter.com/TobyPhln/status/1721053802235621734)
	- xAI PromptIDE is an integrated development environment for prompt engineering and interpretability research. https://x.ai/prompt-ide/ https://twitter.com/xai/status/1721568361883279850
- GitHub Copilot GA
	- https://twitter.com/HamelHusain/status/1723047256180355386
	- workspace https://twitter.com/ashtom/status/1722631796482085227
	- chat https://x.com/ashtom/status/1722330209867993471?s=20
	- mitchell: https://x.com/mitchellh/status/1722346134130348504?s=20
- Microsoft Ignite - copilot everything
	- https://www.theverge.com/23961007/microsoft-ignite-2023-news-ai-announcements-copilot-windows-azure-office
- Adept Experiments: https://www.adept.ai/blog/experiments
	- Workflows: Workflows is powered by ACT-2, a model fine-tuned from the Fuyu family and optimized for UI understanding, knowledge worker data comprehension, and action taking. 
- consistency models
	- krea https://news.ycombinator.com/item?id=38223822
	- live hf space https://huggingface.co/spaces/radames/Real-Time-Latent-Consistency-Model
	- latent consistency and LCM-LoRA are the incremental innovations that spawned the recent work https://huggingface.co/collections/latent-consistency/latent-consistency-model-demos-654e90c52adb0688a0acbe6f
		- https://twitter.com/javilopen/status/1724398666889224590
- TLDraw [Make real](https://x.com/tldraw/status/1724892287304646868?s=46&t=90xQ8sGy63D2OtiaoGJuww)
	- [statecharts and wireframes](https://twitter.com/tldraw/status/1725083976392437894?s=12&t=90xQ8sGy63D2OtiaoGJuww)
	- https://github.com/tldraw/draw-fast
	- small todo app https://twitter.com/Altimor/status/1725678615751438396
	- excalidraw response https://twitter.com/bigansh/status/1729241462712545563
- [Nvidia ChipNeMo](https://twitter.com/DrJimFan/status/1724832446393598283), custom LLM trained on Nvidia’s internal data to generate and optimize software and assist human designers for GPU ASIC and Architecture engineers ![https://cdn.wccftech.com/wp-content/uploads/2023/11/ChipNeMo-diagram-Final.jpg.webp](https://cdn.wccftech.com/wp-content/uploads/2023/11/ChipNeMo-diagram-Final.jpg.webp)
- Lindy.ai https://twitter.com/Altimor/status/1721250514946732190
- Pplx api 
	- pplx 7b and 70b online LLMs https://twitter.com/denisyarats/status/1729909196160930090
	- referencing [FreshLLMs: Refreshing Large Language Models with Search Engine Augmentation](https://arxiv.org/abs/2310.03214)
- DallE Party - gpt4v and dalle in a loop https://dalle.party/?party=0uKfJjQn
- [Visual Anagrams: Generating Multi-View Optical Illusions with Diffusion Models](https://dangeng.github.io/visual_anagrams/) interesting/fun paper and codebase uses Stability AI's Deepfloyd
	- Our method is conceptually simple. We take an off-the-shelf diffusion model and use it to estimate the noise in different views or transformations, ��, of an image. The noise estimates are then aligned by applying the inverse view, ��−1, and averaged together. This averaged noise estimate is then used to take a diffusion step.
- [VectorArt.ai](https://vectorart.ai) - Use the power of generative AI to create infinitely scalable vector images, logos, icons and illustrations for your website, business or app.

## misc and other discussions

- [Karpathy Intro to LLMs talk](https://www.youtube.com/watch?v=zjkBMFhNj_g)
	- with [Sarah Chieng notes](https://mphr.notion.site/Intro-To-Large-Language-Models-LLMs-a89c1750c71545dc88717d01c4552f0d)
	- more thinking about [LLM OS](https://twitter.com/karpathy/status/1723140519554105733?s=12&t=90xQ8sGy63D2OtiaoGJuww)
	- [PagedAttention, Virtual Context, Speculative Decoding, Register Tokens](https://charlesfrye.github.io/programming/2023/11/10/llms-systems.html) and other systems programming ideas for LLMs explained
- [Bill Gates is back again writing about agents](https://www.gatesnotes.com/AI-agents)
- GAIA:  A Benchmark for General AI Assistants from Meta incl Yann LeCun
	- GAIA questions are conceptually simple for humans yet challenging for most advanced AIs: we show that human respondents obtain 92% vs. 15% for GPT-4 equipped with plugins. This notable performance disparity contrasts with the recent trend of LLMs outperforming humans on tasks requiring professional skills in e.g. law or chemistry.
- Shanahan, Reynolds, and McDonnell back again in [Nature](https://www.nature.com/articles/s41586-023-06647-8) on Role play with large language models. instead of dialogue agent as role-playing a single character, see a dialogue agent as a *superposition of simulacra within a multiverse of possible characters.*
- standard pretraining stack
	- Use flash attention 2, parallel attention and feedforward layers, rotary embeddings, pre-layer norm, and probably 8/3 h multipliers but that doesn't matter too much. Basically Mistral + parallel layers (they left a free +10% performance on the table). https://x.com/BlancheMinerva/status/1721380386515669209?s=20
	- Train on a large and diverse dataset, something like C4 along plus high quality known components (academic papers, books, code). Ideally you'd scrape these things freshly instead of using Pile / RP. You want to balance clean w/ diverse. Dedupe, but train for 4 epochs (3T+ total)
	- RLHF HISTORY Entangled Preferences: The History and Risks of Reinforcement Learning and Human Feedback
		- https://x.com/natolambert/status/1721250884481634420?s=20
- long context methods survey paper
	- https://arxiv.org/pdf/2311.12351.pdf
- MFU calculation
	- [Stas Bekman](https://twitter.com/StasBekman/status/1721207940168987113) - This study from 2020 publishes the actual achievable TFLOPS in half-precision for the high-end gpus. e.g., 88% for V100, 93% for A100. Showing that A100@BF16's peak performance is 290 and not 312 TFLOPS. So that means that when we calculate MFU (Model FLOPS Utilization) our reference point shouldn't be the advertised theoretical TFLOPS, but rather the adjusted achievable TFLOPS.
- other good reads
	- [Don't Build AI Products the Way Everyone Else Is Doing It](https://www.builder.io/blog/build-ai) ([builder.io](https://news.ycombinator.com/from?site=builder.io))[103 comments](https://news.ycombinator.com/item?id=38221552)
	- Github Universe wrote about  [The architecture of today’s LLM applications](https://github.blog/2023-10-30-the-architecture-of-todays-llm-applications/) ![https://github.blog/wp-content/uploads/2023/10/LLMapparchitecturediagram.png?resize=4088%2C2148?w=2048](https://github.blog/wp-content/uploads/2023/10/LLMapparchitecturediagram.png?resize=4088%2C2148?w=2048)
	- Lilian Weng wrote a great survey post on [Adversarial Attacks on LLMs ](https://lilianweng.github.io/posts/2023-10-25-adv-attack-llm/) (vs images and [data extraction](https://news.ycombinator.com/item?id=38458683))
- Galactica postmortem https://twitter.com/rosstaylor90/status/1724547381092573352
- [Notable resignation](https://twitter.com/ednewtonrex/status/1724902327151452486) from Stability AI Audio team, over copyright fair use training
- [beautiful illustrated piece](https://www.newyorker.com/humor/sketchbook/is-my-toddler-a-stochastic-parrot) on Stochastic Parrots by the New Yorker
- Google Switch C 1.6T MoE model (old, but being circulated)
	- https://news.ycombinator.com/item?id=38352794
- [$10m **Artificial Intelligence Mathematical Olympiad Prize** (AI-MO Prize)](https://aimoprize.com/) for AI models that can reason mathematically, leading to the creation of a publicly-shared AI model capable of winning a gold medal in the International Mathematical Olympiad (IMO).
- [List of function calling LLMs](https://twitter.com/minimaxir/status/1719793409567932514?s=12&t=90xQ8sGy63D2OtiaoGJuww)
	- [llama-cpp-python grammar](https://til.simonwillison.net/llms/llama-cpp-python-grammars) and on [replicate](https://replicate.com/blog/llama-2-grammars)
	- [outlines](https://x.com/remilouf/status/1719920981219664306?s=20), or [jsonformer, instructor](https://x.com/wangzjeff/status/1719748944241336347?s=20)
	- [glaive function calling v1](https://huggingface.co/glaiveai/glaive-function-calling-v1)
	- [Gorilla LLM](https://twitter.com/shishirpatil_/status/1661780076277678082)
	- [Trelis/Mistral-7B-Instruct-v0.1-function-calling-v2](https://huggingface.co/Trelis/Mistral-7B-Instruct-v0.1-function-calling-v2)
	- [meetkai/functionary-7b-v1.4](https://www.reddit.com/r/LocalLLaMA/comments/158l28c/functionary_new_open_source_llm_that_can_execute/)
	- [openhermes2.5 can do it?](https://twitter.com/abacaj/status/1726343354902802517) bc of [airoboros](https://x.com/jon_durbin/status/1726349280963875139?s=20)
- [Humane AI Pin vs Tab Pin comparison](https://twitter.com/avischiffmann/status/1722803122723258468?s=12&t=90xQ8sGy63D2OtiaoGJuww)
- actually [good defense of standalone vector DBs vs normal DB with vector index](https://news.ycombinator.com/item?id=38419173)
	- meanwhile [people keep writing new VectorDBs, like Kagi does](https://news.ycombinator.com/item?id=38420554&utm_source=wondercraft_ai)



## best memes

- https://twitter.com/EMostaque/status/1726591847282421871
- good meme material https://x.com/AISafetyMemes/status/1726595374402662497?s=20
- https://x.com/paularambles/status/1726606909069988141?s=20
- https://x.com/202accepted/status/1726505578405695713?s=20
- check latent space discord meme channel theres just too many
- laundry buddy memes
	- https://twitter.com/chatgptapp/status/1727174037804355944?s=12&t=90xQ8sGy63D2OtiaoGJuww
	- jeremy howard laundry buddy hate
- make more meme
	- https://x.com/liveoverflow/status/1729798452094128278?s=46&t=90xQ8sGy63D2OtiaoGJuww
	- https://twitter.com/sobedominik/status/1729345233417355278?s=12&t=90xQ8sGy63D2OtiaoGJuww
- where is gemini lol https://x.com/tszzl/status/1730123261504291298?s=20